#############################################################################
##
## Copyright (C) 2021 The Qt Company Ltd.
## Contact: https://www.qt.io/licensing/
##
## This file is part of Qt for Python.
##
## $QT_BEGIN_LICENSE:COMM$
##
## Commercial License Usage
## Licensees holding valid commercial Qt licenses may use this file in
## accordance with the commercial license agreement provided with the
## Software or, alternatively, in accordance with the terms contained in
## a written agreement between you and The Qt Company. For licensing terms
## and conditions see https://www.qt.io/terms-conditions. For further
## information use the contact form at https://www.qt.io/contact-us.
##
## $QT_END_LICENSE$
##
#############################################################################
from __future__ import annotations

"""
This file contains the exact signatures for all functions in module
PySide2.Qt3DLogic, except for defaults which are replaced by "...".
"""

# Module PySide2.Qt3DLogic
import PySide2
try:
    import typing
except ImportError:
    from PySide2.support.signature import typing
from PySide2.support.signature.mapping import (
    Virtual, Missing, Invalid, Default, Instance)

class Object(object): pass

import shiboken2 as Shiboken
Shiboken.Object = Object

import PySide2.Qt3DLogic


class Qt3DLogic(Shiboken.Object):

    class QFrameAction(PySide2.Qt3DCore.QComponent):

        def __init__(self, parent: typing.Optional[PySide2.Qt3DCore.Qt3DCore.QNode] = ...) -> None: ...


    class QLogicAspect(PySide2.Qt3DCore.QAbstractAspect):

        def __init__(self, parent: typing.Optional[PySide2.QtCore.QObject] = ...) -> None: ...


# eof
